_OpenScript( "includes/vector3.lua" );
myindex = 0;
owner = 0;
currenttime = 0;

function onInit()
	_swepsetsound(myindex, "single_shot", "weapon_crowbar.single")
end

function onThink()
end

function onPrimaryAttack()
	if (_PlayerInfo(Owner, "alive") == false) then return; end
	local knife = _EntCreate( "prop_physics" );
	_EntPrecacheModel( "models/mr_pickle/pmario.mdl" );
	_EntSetModel(knife, "models/mr_pickle/pmario.mdl");
	_EntSetKeyValue(knife, "onworldimpact", "stick");
	_EntSetPos(knife, vecAdd(_PlayerGetShootPos(Owner),vector3(0,0,0)))
	_EntSetAng(knife, _PlayerGetShootAng(Owner));
	local power = 20000000;
	local fireforce = vecMul(_PlayerGetShootAng(Owner), vector3(power, power, power));
	_EntSpawn(knife);
	_PhysApplyForce(knife, fireforce);
	_SWEPUseAmmo(MyIndex, 0, 1);
	_EntFire(knife, "kill", "", 5)
	_PlayerViewModelSequence(Owner, ACT_RUN);
	_PlaySoundPlayer(Owner, "weapons/iceaxe/iceaxe_swing1.wav");
end

function Deploy( )
       _PlayerViewModelSequence(Owner, ACT_WALK);
end

function onSecondaryAttack()		

end

function onReload( )
	return true;
end

function getWeaponSwapHands()
	return false;	
end

function getWeaponFOV()
	return 82;	
end


function getWeaponSlot()
	return 4;	
end

function getWeaponSlotPos()
	return 4;	
end

function getFiresUnderwater()
	return true;
end

function getReloadsSingly()
	return true;
end

function getDamage()
	return 0;
end

function getPrimaryShotDelay()
	return 0.7;
end

function getSecondaryShotDelay()
	return 0.3;
end

function getPrimaryIsAutomatic()
	return true;
end

function getSecondaryIsAutomatic()
	return false;
end

function getPrimaryAmmoType()
	return "pistol";
end

function getSecondaryAmmoType()
	return "none";
end

function getMaxClipPrimary()
	return 500;
end

function getMaxClipSecondary()
	return -1;
end

function getDefClipPrimary()
	return 500;
end


function getDefClipSecondary()
	return -1;
end

function getPrimaryScriptOverride()
	return 2;
end

function getSecondaryScriptOverride()
	return 3;
end

function getBulletSpread()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewKick()
	return vector3( 0, 0.0, 0.0);
end

function getViewKickRandom()
	return vector3( 0.0, 0.0, 0.0 );
end

function getViewModel( )
	return "models/mr_pickle/mario_thrower.mdl";
end

function getWorldModel( )
	return "models/mr_pickle/pmario.mdl";
end

function getClassName()
	return "weapon_throwingmario";
end

function getAnimPrefix()
	return "melee";
end

function getPrintName()
	return "Paper Mario thrower";
end

function getHUDMaterial()				
	return "gmod/SWEP/pm_thrower"
end